
package main

import(
	"fmt"
	"encoding/json"
	"errors"
)



type Mock struct{
	DeviceState
	Out [6]Out_desc `json:"outs"`
}


// Lan20 represents a device with multiple outputs

func (l *Mock) SetOut(nr int, val int)error{
	if nr > 5 || nr < 0   {
		return errors.New("Outside Index");
	}
	l.Out[nr].State = val;		
	return nil;
}

func (l *Mock) GetOut(nr int) (int,error) {
	return l.Out[nr].State ,nil 
}

func (l *Mock) GetVersion() (int,error) {
 fmt.Printf ("I'm lan controler but a MOCK \n")
 return 0,nil
}

func (l *Mock) GetAddress()(string,error) {
	return l.Address,nil
}

func (l *Mock) SetReset(nr int, time int , force bool ) (bool,error){
	if nr > 5 || nr < 0 {
		return false,errors.New("Index outside of range");
	}
	
	if l.Out[nr].ResetTime == 0 && ! force {
		return false, nil
	}
	l.Out[nr].ResetTime = time
	return true,nil
}

func (l *Mock) GetStatus()(string,error) {
	jsonData, _ := json.MarshalIndent(l,""," ")
	return  string(jsonData),nil
}


func (l *Mock) Toggle(nr int)error{
	if nr > 5 || nr < 0 {
		return errors.New("Outside of Index");
	}
	if  l.Out[nr].State == 1 {
		 l.Out[nr].State = 0
	} else {
		 l.Out[nr].State = 1
	}

	return nil
}

func (l *Mock) Init() (error){
	for i := 0 ; i < len(l.Out); i++ {
	l.Out[i].Id = i
	l.Out[i].State = 0
	}
	return nil
}
