package main

import(
	"fmt"
	"sync"
	"encoding/json"
)

// DeviceContainter structure to hold objects and provide quick lookups by name
type DeviceContainter struct {
	controlers map[string]Device
	lock	sync.Mutex
}

// NewDeviceContainter creates a new DeviceContainter
func NewDeviceContainter() *DeviceContainter {
	return &DeviceContainter{
		controlers: make(map[string]Device),
	}
}

// Add adds a new object to the set
func (s *DeviceContainter) Add(dev Device) (error) {
	s.lock.Lock()
	defer s.lock.Unlock()
	if (dev != nil){
		addr,err := dev.GetAddress();
		if err == nil {
			s.controlers[addr] = dev
		}else{
			return err
		}
		
	}
	return nil
}

// Get retrieves an object by name
func (s *DeviceContainter) Get(address string) (Device, bool) {
	obj, found := s.controlers[address]
	return obj, found
}

// Remove deletes an object by name
func (s *DeviceContainter) Remove(address string) {
	delete(s.controlers, address)
}
func (s *DeviceContainter) GetAllAddresses() (string, error) {

	addresses := []string{}
	for _, dev := range s.controlers {
		addr,err := dev.GetAddress()
		if err == nil {
			addresses = append(addresses, addr)
		}else {
			return "",err
		}
	}

	jsonData, err := json.Marshal(addresses)
	if err != nil {
		return "", fmt.Errorf("error marshalling JSON: %v", err)
	}

	return string(jsonData), nil
}
