package main

import (
	"errors"
	"fmt"
	"io"
	"net/http"
	"sync"
	"time"
)

var ipLocks = struct {
	sync.Mutex
	locks     map[string]*sync.Mutex
	lastCalls map[string]time.Time
}{locks: make(map[string]*sync.Mutex), lastCalls: make(map[string]time.Time)}

func getIPMutex(ip string) *sync.Mutex {
	ipLocks.Lock()
	defer ipLocks.Unlock()
	if _, exists := ipLocks.locks[ip]; !exists {
		ipLocks.locks[ip] = &sync.Mutex{}
	}
	return ipLocks.locks[ip]
}
// ensureRateLimit wprowadza opóźnienie, aby wymusić odstęp co najmniej 20 ms między żądaniami
func ensureRateLimit(ip string) {
	ipLocks.Lock()
	defer ipLocks.Unlock()

	// Pobierz czas ostatniego żądania dla adresu IP
	lastCall, exists := ipLocks.lastCalls[ip]
	if !exists {
		ipLocks.lastCalls[ip] = time.Now()
		return
	}

	// Oblicz czas, jaki upłynął od ostatniego żądania
	timeSinceLastCall := time.Since(lastCall)

	// Jeśli ostatnie żądanie było mniej niż 20 ms temu, poczekaj
	if timeSinceLastCall < 20*time.Millisecond {
		time.Sleep(20*time.Millisecond - timeSinceLastCall)
	}

	// Zaktualizuj czas ostatniego żądania
	ipLocks.lastCalls[ip] = time.Now()
}




// Http_get wysyła żądanie GET, zwraca ciało odpowiedzi, kod statusu HTTP i błąd.
func Http_get(ip,path string) ([]byte, int, error) {

	if ip == "" {
		return []byte(""), 0, errors.New("IP cannot be empty")
	}
	if path == "" {
		return []byte(""), 0, errors.New("Path cannot be empty")
	}

	// Pełny URL
	url := fmt.Sprintf("http://%s%s", ip, path)
	me  := fmt.Sprintf("http://%s/", ip)

	// Uzyskaj mutex dla danego IP
	ipMutex := getIPMutex(ip)
	ipMutex.Lock() // Zablokuj wysyłanie żądań dla tego IP
	defer ipMutex.Unlock()

	ensureRateLimit(ip)

	client := &http.Client{
		Timeout: 10 * time.Second,
	}

	req, err := http.NewRequest("GET", url, nil)
	if err != nil {
		return []byte(""), 0, err
	}

	req.Header.Set("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8")
	req.Header.Set("Accept-Encoding", "gzip, deflate")
	req.Header.Set("Accept-Language", "en-US,en;q=0.5")
	req.Header.Set("Accept-Language", "pl,en-US;q=0.7,en;q=0.3")
	req.Header.Set("Cache-Control", "no-cache")
	req.Header.Set("Connection", "keep-alive")
	req.Header.Set("DNT", "1")
	req.Header.Set("Pragma", "no-cache")
	req.Header.Set("Priority", "u=0")
	req.Header.Set("Referer", me)
	req.Header.Set("Sec-GPC", "1")
	req.Header.Set("Upgrade-Insecure-Requests", "1")
	req.Header.Set("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36")

	resp, err := client.Do(req)
	if err != nil {
		return []byte(""), 0, err
	}
	defer resp.Body.Close()

	body, err := io.ReadAll(resp.Body)
	if err != nil {
		return []byte(""), resp.StatusCode, err
	}

	if resp.StatusCode != http.StatusOK {
		return []byte(""), resp.StatusCode, fmt.Errorf("HTTP error: %d %s", resp.StatusCode, http.StatusText(resp.StatusCode))
	}

	return body, resp.StatusCode, nil
	//return string(body), resp.StatusCode, nil
}
