package main

import (
	"log"
	"net/http"
)

var ControlerList  *DeviceContainter 

func main() {
	
	ControlerList = NewDeviceContainter()  

	// Initialize the HTTP server
	router := setupRouter()

    	corsRouter := corsMiddleware(router)
	// Start the HTTP server on port 8080
	log.Println("Starting server on :8080")
	err := http.ListenAndServe(":8080", corsRouter)
	if err != nil {
		log.Fatalf("Could not start server: %s\n", err.Error())
	}
}

func corsMiddleware(next http.Handler) http.Handler {
    return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
        w.Header().Set("Access-Control-Allow-Origin", "*")
        w.Header().Set("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS")
        w.Header().Set("Access-Control-Allow-Headers", "Content-Type, Authorization")

        // Obsługa zapytań preflight (OPTIONS)
        if r.Method == http.MethodOptions {
            w.WriteHeader(http.StatusOK)
            return
        }

        next.ServeHTTP(w, r)
    })
}
