
package main

import(
	"fmt"
	"encoding/xml"
	"encoding/json"
	"time"
	"errors"
)



type Lan20 struct{
	DeviceState
	Out [5]Out_desc `json:"outs"`
}


// Lan20 represents a device with multiple outputs

func (l *Lan20) SetOut(nr int, val int)error{
	if nr > 5 || nr < 0   {
		return errors.New("Outside Index");
	}
	
	path := fmt.Sprintf("/outs.cgi?out%d=%d", nr, val)
	_, _, err := Http_get(l.Address, path)

	if err != nil {
		return err;
	}
	
	l.UpdateTime = time.Time{}
	return nil;
}

func (l *Lan20) GetOut(nr int) (int,error) {
	_,err := l.get_data();
	return l.Out[nr].State ,err 
}

func (l *Lan20) GetVersion()(int,error) {
	fmt.Printf ("I'm lan controler in version 2\n")
	return 2,nil
}

func (l *Lan20) GetAddress()(string,error) {
	if l.Address == "" {
		return "",errors.New("Lan 2.0 NO ADDRESS ")
	}
	return l.Address,nil
}
type st0 struct{
	XMLName xml.Name `xml:"response"`
	Out0 int `xml:"out0"`
	Out1 int `xml:"out1"`
	Out2 int `xml:"out2"`
	Out3 int `xml:"out3"`
	Out4 int `xml:"out4"`
}

func (l *Lan20) parseSt0(data []byte) error {
	var v st0
	err := xml.Unmarshal(data, &v)
	if(err != nil) {
		return err
	}
	l.Out[0].State = v.Out0
	l.Out[1].State = v.Out1
	l.Out[2].State = v.Out2
	l.Out[3].State = v.Out3
	l.Out[4].State = v.Out4

	return nil
}
type st2 struct{
	XMLName xml.Name `xml:"response"`
	Reset_time0	int 	`xml:"r0"`
	Reset_time1	int 	`xml:"r1"`
	Reset_time2	int 	`xml:"r2"`
	Reset_time3	int 	`xml:"r3"`
	Reset_time4	int 	`xml:"r4"`
	Name0  string	`xml:"r5"`
	Name1  string	`xml:"r6"`
	Name2  string	`xml:"r7"`
	Name3  string	`xml:"r8"`
	Name4  string	`xml:"r9"`

}

func (l *Lan20) parseSt2(data []byte) error {
	var v st2
	err := xml.Unmarshal(data, &v)
	if(err != nil) {
		return err
	}
	l.Out[0].ResetTime = v.Reset_time0
	l.Out[1].ResetTime = v.Reset_time1
	l.Out[2].ResetTime = v.Reset_time2
	l.Out[3].ResetTime = v.Reset_time3
	l.Out[4].ResetTime = v.Reset_time4

	l.Out[0].Name = v.Name0
	l.Out[1].Name = v.Name1
	l.Out[2].Name = v.Name2
	l.Out[3].Name = v.Name3
	l.Out[4].Name = v.Name4
	return nil
}

func (l *Lan20) download(file string) ([]byte,error){

	path := fmt.Sprintf("/%s", file)
	Body, _, err := Http_get(l.Address, path)
	if err != nil {
		return nil,err;
	}

	return Body, nil;
}

func (l *Lan20) get_data()(bool, error){

	if(time.Since(l.UpdateTime) <= 10*time.Second){
		return false, nil;
	}

	Body ,err := l.download("st0.xml")
	if err != nil {
		return false, err;
	}
	err = l.parseSt0(Body)
	if err != nil {
		return false, err;
	}

	Body ,err = l.download("st2.xml")
	if err != nil {
		return false, err;
	}
	
	err = l.parseSt2(Body)
	if err != nil {
		return false, err;
	}

	l.UpdateTime = time.Now()
	return true,nil;

}

func (l *Lan20) SetReset(nr int, time int , force bool ) (bool,error){
	if nr > 5 || nr < 0 {
		return false,errors.New("Index outside of range");
	}
	
	if l.Out[nr].ResetTime == 0 && ! force {
		return false, nil
	}

	path:= fmt.Sprintf("ind.cgi?r%d=%d",nr, time);
	_, err := l.download(path)

	if err != nil{
		return false,err
	}

	return true,nil
}

func (l *Lan20) GetStatus()(string,error) {
	_,err := l.get_data()
	if err != nil {
		return "",err
	}
	jsonData, err := json.MarshalIndent(l,""," ")
	if err != nil {
		return "",err
	}
	return  string(jsonData),nil
}


func (l *Lan20) Toggle(nr int)error{
	if nr > 5 || nr < 0 {
		return errors.New("Outside of Index");
	}
	link:=fmt.Sprintf("outs.cgi?out=%d",nr);
	_,err := l.download(link)
	return err
}

func (l *Lan20) Init()(error){
	for i := 0 ; i < len(l.Out); i++ {
	l.Out[i].Id = i
	}
	return nil
}
